from django import forms

from .models import Post


class PostForm(forms.ModelForm):

    class Meta:
        # Автоматично генеруємо стандартну форму на базі моделі...
        model = Post
        fields = ['title', 'description', 'content', 'category']

        # ... Єдине, що перевизначаємо віджет для поля 'опис'.
        # Робимо менше рядків (2). За замовчуванням їх більше
        widgets = {
            'description': forms.Textarea(attrs={
                                          'rows': 2,
                                          'cols': 40
                                          }),
        }
