# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(serialize=False, auto_created=True, verbose_name='ID', primary_key=True)),
                ('name', models.CharField(max_length=255, verbose_name='назва')),
            ],
            options={
                'verbose_name_plural': 'Категорії',
                'verbose_name': 'Категорія',
            },
        ),
        migrations.CreateModel(
            name='Post',
            fields=[
                ('id', models.AutoField(serialize=False, auto_created=True, verbose_name='ID', primary_key=True)),
                ('title', models.CharField(max_length=255, verbose_name='заголовок')),
                ('description', models.TextField(max_length=1000, verbose_name='опис')),
                ('content', models.TextField(verbose_name='вміст')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='час створення')),
                ('category', models.ForeignKey(to='blog.Category', verbose_name='категорія')),
            ],
            options={
                'verbose_name_plural': 'Записи',
                'verbose_name': 'Запис',
                'ordering': ['-created_at'],
            },
        ),
    ]
