"""
Here be production settings
"""

import os
from .base import *

DEBUG = False
TEMPLATE_DEBUG = DEBUG

SECRET_KEY = os.getenv('SECRET_KEY', SECRET_KEY)

CSRF_COOKIE_SECURE = True
SESSION_COOKIE_SECURE = True

# Parse database configuration from $DATABASE_URL
# import dj_database_url
# DATABASES['default'] =  dj_database_url.config()

# Enable Connection Pooling
# DATABASES['default']['ENGINE'] = 'django_postgrespool'

# Honor the 'X-Forwarded-Proto' header for request.is_secure()
SECURE_PROXY_SSL_HEADER = ('HTTP_X_FORWARDED_PROTO', 'https')

# Allow all host headers
ALLOWED_HOSTS = ['*']
